<?php
/*--------------------------------------------------------------------------------------------------
    GroupMapperInterface.php 2020-02-05
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\ProductModifiers\Database\Core\Mappers\Interfaces;

use Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups\GroupDTO;
use Gambio\Shop\ProductModifiers\Database\Presentation\Mappers\Exceptions\PresentationMapperNotFoundException;
use Gambio\Shop\ProductModifiers\Groups\Builders\InvalidGroupSourceException;
use Gambio\Shop\ProductModifiers\Groups\GroupInterface;

interface GroupMapperInterface
{
    /**
     * @param GroupDTO $dto
     *
     * @return GroupInterface
     * @throws InvalidGroupSourceException
     * @throws PresentationMapperNotFoundException
     */
    public function mapGroup(GroupDTO $dto): GroupInterface;
    
    
    /**
     * @param GroupMapperInterface $next
     */
    public function setNext(GroupMapperInterface $next): void;
    
}